using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using Verse;

namespace RimWorld{
public class Building_Storage : Building, ISlotGroupParent
{
		//Working vars
	public SlotGroup		slotGroup;
	public StorageSettings	settings;

	private List<IntVec3>	cachedOccupiedCells = null;

	//=======================================================================
	//========================== SlotGroupParent interface===================
	//=======================================================================

	public bool StorageTabVisible { get { return true; } }
	public SlotGroup GetSlotGroup(){return slotGroup;}
	public virtual void Notify_ReceivedThing(Thing newItem)
	{
		if( Faction == Faction.OfPlayer && newItem.def.storedConceptLearnOpportunity != null )
			LessonAutoActivator.TeachOpportunity(newItem.def.storedConceptLearnOpportunity, OpportunityType.GoodToKnow);
	}
	public virtual void Notify_LostThing(Thing newItem){/*Nothing by default*/}
	public virtual IEnumerable<IntVec3> AllSlotCells()
	{
		foreach( IntVec3 c in GenAdj.CellsOccupiedBy(this) )
		{
			yield return c;
		}
	}
	public List<IntVec3> AllSlotCellsList()
	{
		if( cachedOccupiedCells == null )
			cachedOccupiedCells = AllSlotCells().ToList();

		return cachedOccupiedCells;
	}
	public StorageSettings GetStoreSettings()
	{
		return settings;
	}
	public StorageSettings GetParentStoreSettings()
	{
		return def.building.fixedStorageSettings;
	}
	public string SlotYielderLabel(){return LabelCap;}
	


	//=======================================================================
	//============================== Other stuff ============================
	//=======================================================================

	public override void PostMake()
	{
		base.PostMake();
		settings = new StorageSettings(this);

		if( def.building.defaultStorageSettings != null )
			settings.CopyFrom( def.building.defaultStorageSettings );
	}

	public override void SpawnSetup(Map map)
	{
		base.SpawnSetup(map);

		cachedOccupiedCells = AllSlotCells().ToList(); // recalculate cells before creating a slot group
		slotGroup = new SlotGroup(this);
	}
	
	public override void ExposeData()
	{
		base.ExposeData();
		Scribe_Deep.LookDeep(ref settings, "settings", this);
	}

	public override void DeSpawn()
	{
		if( slotGroup != null )
			slotGroup.Notify_ParentDestroying();

		base.DeSpawn();
	}
	
	public override IEnumerable<Gizmo> GetGizmos()
	{
		foreach( var g in base.GetGizmos() )
		{
			yield return g;
		}

		foreach( var g in StorageSettingsClipboard.CopyPasteGizmosFor(settings) )
		{
			yield return g;
		}
	}
}}